<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Commande extends Model 
{

    protected $table = 'commandes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id', 'date_commande', 'user_id', 'statut_commande');
    protected $visible = array('prix_total');

    public function relationUser()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function relationLigneCommande()
    {
        return $this->hasOne('App\Models\LigneCommande');
    }

}